/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing;

import com.aptana.core.epl.util.ILRUCacheable;
import com.aptana.core.epl.util.LRUCacheWithSoftPrunedValues;
import com.aptana.core.logging.IdeLog;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParseStateCacheKey;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IParserPool;
import com.aptana.parsing.Messages;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParsingPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;

public class ParsingEngine {
    private LRUCacheWithSoftPrunedValues<IParseStateCacheKey, CacheValue> fParseCache;
    private IParserPoolProvider fParserPoolProvider;
    private final Object fParseCacheLock = new Object();
    public static final int MINIMUM_NUMBER_OF_CHARS_TO_ENTER_CACHE = 3072;
    public static final int MAXIMUM_NUMBER_OF_CHARS_IN_STRONG_REFERENCES_CACHE = 409600;
    private final int fMinimumNumberOfCharsToEnterCache;

    protected ParsingEngine(IParserPoolProvider parserPoolProvider, int cacheSize, int minCacheElementSize) {
        this.fParseCache = new LRUCacheWithSoftPrunedValues(cacheSize);
        this.fParserPoolProvider = parserPoolProvider;
        this.fMinimumNumberOfCharsToEnterCache = minCacheElementSize;
    }

    public ParsingEngine(IParserPoolProvider parserPoolProvider) {
        this(parserPoolProvider, 409600, 3072);
    }

    public void dispose() {
        this.fParseCache = null;
    }

    public void clearCache() {
        if (this.fParseCache == null) {
            return;
        }
        this.fParseCache.flush();
    }

    /*
     * Exception decompiling
     */
    public ParseResult parse(String contentTypeId, IParseState parseState) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 4[TRYBLOCK]], but top level block is 16[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ParseResult noCacheParse(String contentTypeId, IParseState parseState) throws Exception {
        IParserPool pool = null;
        IParser parser = null;
        pool = this.fParserPoolProvider.getParserPool(contentTypeId);
        if (pool == null) {
            if (IdeLog.isInfoEnabled((Plugin)ParsingPlugin.getDefault(), null)) {
                String message = MessageFormat.format(Messages.ParserPoolFactory_Cannot_Acquire_Parser_Pool, contentTypeId);
                IdeLog.logInfo((Plugin)ParsingPlugin.getDefault(), (String)message, (String)"com.aptana.parsing/debug/parsing");
            }
            return ParseResult.EMPTY;
        }
        parser = (IParser)pool.checkOut();
        if (parser == null) {
            String message = MessageFormat.format(Messages.ParserPoolFactory_Cannot_Acquire_Parser, contentTypeId);
            IdeLog.logError((Plugin)ParsingPlugin.getDefault(), (String)message, (String)"com.aptana.parsing/debug/parsing");
            return ParseResult.EMPTY;
        }
        try {
            ParseResult parseResult = parser.parse(parseState);
            return parseResult;
        }
        finally {
            pool.checkIn(parser);
        }
    }

    private static class CacheValue
    implements ILRUCacheable {
        private IParseStateCacheKey fCachedParseStateKey;
        private ParseResult fCachedParseResult;
        private final Object fLock = new Object();
        private volatile boolean fResultGotten = false;
        private final int fcacheFootprint;

        public int getCacheFootprint() {
            return this.fcacheFootprint;
        }

        public CacheValue(IParseStateCacheKey parseStateKey, int cacheFootprint) {
            this.fCachedParseStateKey = parseStateKey;
            this.fcacheFootprint = cacheFootprint;
        }

        public boolean requiresReparse(IParseStateCacheKey newCacheKey) {
            return this.fCachedParseStateKey.requiresReparse(newCacheKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParseResult getResult() {
            while (!this.fResultGotten) {
                Object object = this.fLock;
                synchronized (object) {
                    if (!this.fResultGotten) {
                        try {
                            this.fLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.fCachedParseResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(ParseResult parseResult) {
            Assert.isNotNull((Object)parseResult);
            this.fCachedParseResult = parseResult;
            Object object = this.fLock;
            synchronized (object) {
                this.fResultGotten = true;
                this.fLock.notifyAll();
            }
        }
    }

    public static interface IParserPoolProvider {
        public IParserPool getParserPool(String var1);
    }
}

